/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class Beggar
extends AbstractImageEvent {
    public static final String ID = "Beggar";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Beggar");
    public static final String NAME = Beggar.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Beggar.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Beggar.eventStrings.OPTIONS;
    private CurScreen screen;
    private static final int GOLD_COST = 75;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String CANCEL_DIALOG = DESCRIPTIONS[1];
    private static final String PURGE_DIALOG = DESCRIPTIONS[2];
    private static final String POST_PURGE_DIALOG = DESCRIPTIONS[3];

    public Beggar() {
        super(NAME, DIALOG_1, "images/events/beggar.jpg");
        if (AbstractDungeon.player.gold >= 75) {
            GenericEventDialog.setDialogOption(OPTIONS[0] + 75 + OPTIONS[1], AbstractDungeon.player.gold < 75);
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[2] + 75 + OPTIONS[3], AbstractDungeon.player.gold < 75);
        }
        GenericEventDialog.setDialogOption(OPTIONS[5]);
        this.hasDialog = true;
        this.hasFocus = true;
        this.screen = CurScreen.INTRO;
    }

    @Override
    public void update() {
        super.update();
        if (!AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            CardCrawlGame.sound.play("CARD_EXHAUST");
            AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(AbstractDungeon.gridSelectScreen.selectedCards.get(0), Settings.WIDTH / 2, Settings.HEIGHT / 2));
            AbstractDungeon.player.masterDeck.removeCard(AbstractDungeon.gridSelectScreen.selectedCards.get(0));
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.openMap();
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    AbstractDungeon.genericEventDialog.loadImage("images/events/cleric.jpg");
                    GenericEventDialog.updateBodyText(PURGE_DIALOG);
                    AbstractDungeon.player.loseGold(75);
                    GenericEventDialog.clearAllDialogs();
                    GenericEventDialog.setDialogOption(OPTIONS[4]);
                    this.logMetric("Gave Gold");
                    this.screen = CurScreen.GAVE_MONEY;
                    break;
                }
                GenericEventDialog.updateBodyText(CANCEL_DIALOG);
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[5]);
                this.screen = CurScreen.LEAVE;
                this.logMetric("Ignored");
                break;
            }
            case GAVE_MONEY: {
                AbstractDungeon.gridSelectScreen.open(CardGroup.getGroupWithoutBottledCards(AbstractDungeon.player.masterDeck.getPurgeableCards()), 1, OPTIONS[5], false, false, false, true);
                GenericEventDialog.updateBodyText(POST_PURGE_DIALOG);
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[5]);
                this.screen = CurScreen.LEAVE;
                break;
            }
            case LEAVE: {
                this.openMap();
                break;
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    public static enum CurScreen {
        INTRO,
        LEAVE,
        GAVE_MONEY;

    }
}

